'
' This program output the voice file DEMO.VOC
'

' $INCLUDE: 'SBC.BI'
' $INCLUDE: 'SBCSYS.BI'
' $INCLUDE: 'SBCVOICE.BI'

DECLARE   SUB  OUTVOCFILE(filename$)
DECLARE   SUB  SHOWERROR()

REM $DYNAMIC
CLEAR

' Following statements free memory for the loadable drivers.
' You must free sufficient memory for the loadable drivers.
' The free memory must be larger than the driver file size.

' Free 8K memory for the CTVDSK.DRV at the moment
DUMMY = SETMEM(-8192)

' Following statements free memory for the Disk Double Buffer
' Two 32K buffers are released by BASIC
DUMMY = SETMEM(-16400)
DUMMY = SETMEM(-16400)
DUMMY = SETMEM(-16400)
DUMMY = SETMEM(-16400)

CLS

PRINT "SBK Basic Voice Output (disk version) Example"

IF (SBGETENV% = 0) THEN
    IF SBCHKCRD% THEN
        IF SBTSTINT% THEN
            IF SBTSTDMA% >= 0 THEN

                ' Load CTVDSK.DRV
                DRVADDX% = LOADDRV% ("CTVDSK.DRV")

                ' If driver loaded successfully
                IF (DRVADDX% <> 0) THEN

                    ' Set driver address
                    DSKADDX (DRVADDX%)

                    ' Initial the driver, with 64K buffer as double buffer
                    IF ( SVDINIT%((16)) = 0 ) THEN

                        ' Off DAC speaker
                        CALL SVDSPKER(INT(0))

                        ' Output the voice file
                        CALL OUTVOCFILE("DEMO.VOC")

                        ' Terminate the driver
                        CALL SVDEXIT

                    ELSE
                        CALL SHOWERROR
                    ENDIF

                    ' Release memory allocated for CTVDSK
                    CALL FREEMEM(DRVADDX%)
                ENDIF
            ELSE
                PRINT "Error on DMA channel."
            ENDIF
        ELSE
            PRINT "Error on interrupt."
        ENDIF
    ELSE
        PRINT "Sound Blaster Card not found or wrong I/O setting"
    ENDIF
ELSE
    PRINT "BLASTER environment variable not set or incomplete or invalid."
ENDIF

' Return the memory to BASIC
DUMMY = SETMEM(16400)
DUMMY = SETMEM(16400)
DUMMY = SETMEM(16400)
DUMMY = SETMEM(16400)

DUMMY = SETMEM(8192)

END


' ------------------------------------------------------------------------ '

FUNCTION LOADDRV% (szDrvName$)

    DIM szDrvFile$, Handle%, dwFileLen&, wDrvSeg%


    LOADDRV% = 0

    ' search SOUND environment for driver
    szDrvFile$ = ENVIRON$("SOUND")

    IF (szDrvFile$ <> "") THEN
        szDrvFile$ = szDrvFile$ + "\DRV\" + szDrvName$

        IF (FINDFILE%(szDrvFile$) = 0) THEN
            szDrvFile$ = ""
        ENDIF
    ENDIF

    ' search the current directory for driver
    IF (szDrvFile$ = "") THEN
        szDrvFile$ = szDrvName$
    ENDIF

    IF (FINDFILE%(szDrvFile$) <> 0) THEN
        Handle% = DOSOPEN%(szDrvFile$)

        IF (Handle% <> 0) THEN
            dwFileLen& = FILESIZE(Handle%)

            wDrvSeg% = ALLOCMEM(INT((dwFileLen& + 15) / 16))

            IF (wDrvSeg% <> 0) THEN
                IF DOSREAD%(Handle%, INT(0), wDrvSeg%, dwFileLen&) THEN
                    LOADDRV% = wDrvSeg%
                ENDIF
            ENDIF

            DOSCLOSE(Handle%)
        ELSE
            PRINT "Error in opening " + szDrvFile$
        ENDIF
    ELSE
        PRINT "Driver file " + szDrvName$ + " does not exist ..."
    ENDIF

END FUNCTION


' ------------------------------------------------------------------------ '


REM %STATIC
SUB  OUTVOCFILE(filename$)

     DIM  handle AS INTEGER, userkey AS INTEGER

     ' Open the file using DOS function
     handle = DOSOPEN%(filename$)

     IF (handle <> 0) THEN

	  ' Turn on speaker
	  SVDSPKER(INT(1))

	  ' Start the output
	  IF (SVDOUTPUT%(handle) = 0) THEN

	       WHILE CTVOICE% <> 0

		    c$ = INKEY$

		    IF c$ <> "" THEN

			 userkey = INT(ASC(LEFT$(c$, 1)))

			 SELECT CASE userkey
			      CASE ASC("S"), ASC("s"), 27
				   CALL SVDSTOP
			      CASE ASC("P"), ASC("p")
				   CALL SVDPAUSE
			      CASE ASC("C"), ASC("c")
				   CALL SVDCONT
			      CASE ASC("B"), ASC("b")
				   SVDBREAK(INT(1))
			 END SELECT

		    END IF

	       WEND

	  ELSE
	       CALL SHOWERROR
	  ENDIF
     ELSE
	  PRINT "Open " +filename$ + "error."
     ENDIF

END SUB


' ------------------------------------------------------------------------ '


SUB  SHOWERROR

' This function show the error code from the driver

     DIM  errcode AS INTEGER

     errcode = SVDDRVERR%

     PRINT "Driver error ="; errcode

     errcode = SVDEXTERR%

     IF (errcode <> 0) THEN
        PRINT "Dos error ="; errcode
     ENDIF

END SUB
